## Ganzeboom's "iskoroot.sps" in a data frame
load("isco88-egp-table.RData")


## Translation of Ganzeboom's "iskopromo.sps"
## isco88: Vector of ISCO-88 codes
## sempl: Logical vector, TRUE if self-employed
## nspsd: Number of supervised workers/employees

isco88.promote <- function(isco88,sempl,nsv){
  
  out <- isco88
  out[sempl & out==6130] <- 1311
  
  nsv[!is.finite(nsv)] <- -1
  
  nsv[out == 7510 & nsv < 0] <- 5
  out[out >= 6100 & out <= 6133 & nsv >= 1] <- 1311
  out[out >= 9200 & out <= 9213 & nsv > 1] <- 6132
  
  recout <- recode(out,
                   1311 -> 1221,
                   1312 -> 1222,
                   1313 -> 1223,
                   1314 -> 1224,
                   1315 -> 1225,
                   1316 -> 1226,
                   1317 -> 1227,
                   1318 -> 1228,
                   1319 -> 1229,
                   c(1300,1310) -> 1220,
                   otherwise="copy"
  )
  out <- ifelse(nsv >= 11,recout,out)
  
  recout <- recode(out,
                   1221 -> 1311,
                   1222 -> 1312,
                   1223 -> 1313,
                   1224 -> 1314,
                   1225 -> 1315,
                   1226 -> 1316,
                   1227 -> 1317,
                   1228 -> 1318,
                   1229 -> 1319,
                   c(1200, 1210, 1220) -> 1310,
                   otherwise="copy"
  )
  out <- ifelse(nsv >= 1 & nsv <= 10,recout,out)
  
  out[(out == 1220 | out >= 1222 & out <= 1229) & sempl & nsv >= 11] <- 1210
  
  out
}

isco88.2egp <- function(isco88,sempl,nsv){
  
  # Apply potential promotion of certain occupations
  isco88 <- isco88.promote(isco88,sempl,nsv)
  
  # Use translation table of occupations
  ii <- match(isco88,isco88.egp.table$ISCO88)
  egp <- isco88.egp.table$EGP[ii]
  
  # p codes promotabilty of certain occupations
  p <- isco88 >= 1000 & isco88 <= 9299
  
  # d codes degradability of certain occupations
  d <- (isco88 >= 1300 & isco88 <= 1319 | 
          isco88 >= 3400 & isco88 <= 3439 |
          isco88 >= 4000 & isco88 <= 5230)
  
  egp[egp==3 & nsv >= 1] <- 1
  egp[d & sempl & egp %in% 2:3] <- 4
  egp[p & sempl & egp %in% 7:9] <- 5
  egp[egp == 8 & nsv >= 1] <- 7
  egp[egp == 10 & sempl] <- 11
  egp[egp == 4 & nsv < 1] <- 5
  egp[egp == 5 & nsv >=1] <- 4
  egp[egp %in% 2:4 & nsv >= 10] <- 1
  
  egp <- recode(egp,4->5,5->6,otherwise="copy")
  egp[egp==3 & isco88 %in% c(4142,4190,4200:4215,5000:5239)] <- 4
  
  egp
}

EGPlabels_long <- c(
  "Higher-grade professionals, administrators, and officials; managers in large industrial establishments; large proprietors",
  "Lower-grade professionals, administrators, and officials, higher-grade technicians; managers in small industrial establishments; supervisors of non-manual employees",
  "Routine non-manual employees, higher grade (administration and commerce)",
  "Routine non-manual employees, lower grade (sales and services)",
  "Small proprietors, artisans, etc., with employees",
  "Small proprietors, artisans, etc., without employees",
  "Lower-grade technicians; supervisors of manual workers",
  "Skilled manual workers",
  "Semi-skilled and unskilled manual workers (not in agriculture, etc.)",
  "Agricultural and other workers in primary production",
  "Farmers and smallholders; other self-employed workers in primary production"
)

EGPlabels_romdig <- c(
  "I","II","IIIa","IIIb","IVa","IVb","V","VI","VIIa","VIIb","IVc"
)

